
; Listing generator, which shows generated bytes next to offset in the output file
; and assumed address in memory (limited to the constant term if an address is a linear polynomial).
; The listing is stored in a file with .LST extension.

define Listing? Listing

namespace Listing

	virtual at 0
		HexDigits:: db '0123456789ABCDEF'
	end virtual

	spc0 := ''
	repeat 34, i:0
	       spc#% := spc#i bappend ' '
	end repeat

	collected_source = ''
	collected_$ = $
	collected_$% = $%
	collected_$%% = $%%

	calminstruction generate
		local	source, $, $%, $%%

	    reverse:
		take	source, collected_source
		take	$, collected_$
		take	$%, collected_$%
		take	$%%, collected_$%%
		jyes	reverse

		local	offset
		compute offset, $%

	    main:
		take	, $%
		take	, $%%
		take	$%, $%
		jno	done

		check	source
		jno	next

		local	undefined_bytes, defined_bytes
		compute undefined_bytes, $% - $%%
		compute defined_bytes, $%% - offset
		compute offset, $%

		local	counter, digit

		compute counter, 16
		emit	1, '['
	    print_address:
		compute counter, counter - 1
		compute digit, ($ shr (counter shl 2)) and 0Fh
		load	digit, HexDigits:digit, 1
		emit	1, digit
		check	counter
		jyes	print_address
		emit	2, '] '

		check	defined_bytes > 0
		jyes	bytes_present
		emit	34, spc34
		jump	print_source

	    bytes_present:
		compute counter, 8
	    print_offset:
		compute counter, counter - 1
		compute digit, (($%-undefined_bytes-defined_bytes) shr (counter shl 2)) and 0Fh
		load	digit, HexDigits:digit, 1
		emit	1, digit
		check	counter
		jyes	print_offset

		local	column, byte

		emit	2, ': '
		compute column, 0
	    print_bytes:
		check	defined_bytes > 0
		jno	fill_up
		load	byte, $% - undefined_bytes - defined_bytes, 1
		check	column = 8
		jno	print_byte
		compute column, 0
		emit	1, ' '
		emit	lengthof source, source
		emit	2, 0A0Dh
		emit	29, spc29
		compute source, ''
	    print_byte:
		compute digit, byte shr 4
		load	digit, HexDigits:digit, 1
		emit	1, digit
		compute digit, byte and 0Fh
		load	digit, HexDigits:digit, 1
		emit	1, digit
		emit	1, ' '
		compute defined_bytes, defined_bytes - 1
		compute column, column + 1
		jump	print_bytes
	    fill_up:
		check	column >= 8
		jyes	print_source
		emit	3, spc3
		compute column, column + 1
		jump	fill_up
	    print_source:
		emit	1, ' '
		emit	lengthof source, source
		emit	2, 0A0Dh
	    next:
		take	, source
		take	, $
		jump	main
	    done:
	end calminstruction

end namespace

postpone ?
	purge ?
	virtual as 'lst'
		Listing.generate
	end virtual
end postpone

calminstruction ? &line&
	local	tmp
	arrange tmp, line
	stringify tmp
	take	Listing.collected_source, tmp
	compute tmp, $ scale 0
	take	Listing.collected_$, tmp
	compute tmp, $%
	take	Listing.collected_$%, tmp
	compute tmp, $%%
	take	Listing.collected_$%%, tmp
	assemble line
end calminstruction

calminstruction restartout? origin
	arrange origin, =restartout origin
	assemble origin
    reset:
	take	, Listing.collected_source
	take	, Listing.collected_$
	take	, Listing.collected_$%
	take	, Listing.collected_$%%
	jyes	reset
end calminstruction
