; structures

struc EXCEPTION_POINTERS {
    .ExceptionRecord dd ?  ; pointer to EXCEPTION_RECORD
    .ContextRecord   dd ?  ; pointer to CONTEXT
}

virtual at 0
    EXCEPTION_POINTERS EXCEPTION_POINTERS
end virtual
;---

struc EXCEPTION_RECORD {
    .ExceptionCode	  dd ?
    .ExceptionFlags	  dd ?
    .ExceptionRecord	  dd ?
    .ExceptionAddress	  dd ?
    .NumberParameters	  dd ?
    .ExceptionInformation dd ?
}

virtual at 0
    EXCEPTION_RECORD EXCEPTION_RECORD
end virtual
;---

struc FLOATING_SAVE_AREA {
    .ControlWord	  dd ?
    .StatusWord 	  dd ?
    .TagWord		  dd ?
    .ErrorOffset	  dd ?
    .ErrorSelector	  dd ?
    .DataOffset 	  dd ?
    .DataSelector	  dd ?
    .RegisterArea	  rb SIZE_OF_80387_REGISTERS
    .Cr0NpxStatedd	  dd ?
}
;---

struc CONTEXT {
    .ContextFlags	  dd ?
    .Dr0		  dd ?
    .Dr1		  dd ?
    .Dr2		  dd ?
    .Dr3		  dd ?
    .Dr6		  dd ?
    .Dr7		  dd ?
    .FloatSave		  FLOATING_SAVE_AREA
    .SegGs		  dd ?
    .SegFs		  dd ?
    .SegEs		  dd ?
    .SegDs		  dd ?
    .Edi		  dd ?
    .Esi		  dd ?
    .Ebx		  dd ?
    .Edx		  dd ?
    .Ecx		  dd ?
    .Eax		  dd ?
    .Ebp		  dd ?
    .Eip		  dd ?
    .SegCs		  dd ?
    .EFlags		  dd ?
    .Esp		  dd ?
    .SegSs		  dd ?
    .ExtendedRegisters	  rb MAXIMUM_SUPPORTED_EXTENSION
}

virtual at 0
    CONTEXT CONTEXT
end virtual
;---

; constants

EXCEPTION_MAXIMUM_PARAMETERS = 15
MAXIMUM_SUPPORTED_EXTENSION  = 512
SIZE_OF_80387_REGISTERS      = 80

EXCEPTION_EXECUTE_HANDLER     = 1
EXCEPTION_CONTINUE_SEARCH     = 0
EXCEPTION_CONTINUE_EXECUTION  = -1

CONTEXT_DEBUG_REGISTERS       = $10010
THREAD_SET_CONTEXT	      = $0010

; bye
