
format PE console 4.0
entry start

include 'win32ax.inc'
include 'jni.inc'

section '.text' code readable executable

start:

	invoke	RegOpenKeyEx,HKEY_LOCAL_MACHINE,'SOFTWARE\JavaSoft\Java Runtime Environment',0,KEY_READ,tmp
	test	eax,eax
	jnz	init_error
	mov	ebx,1000h
	xchg	ebx,[tmp]
	invoke	RegQueryValueEx,ebx,'CurrentVersion',0,NULL,jvm_library,tmp
	test	eax,eax
	jnz	init_error
	invoke	RegOpenKeyEx,ebx,jvm_library,0,KEY_READ,tmp
	test	eax,eax
	jnz	init_error
	mov	esi,1000h
	xchg	esi,[tmp]
	invoke	RegQueryValueEx,esi,'RuntimeLib',0,NULL,jvm_library,tmp
	test	eax,eax
	jnz	init_error
	invoke	RegCloseKey,esi
	invoke	RegCloseKey,ebx

	invoke	LoadLibrary,jvm_library
	test	eax,eax
	jz	init_error
	invoke	GetProcAddress,eax,jvm_function
	test	eax,eax
	jz	init_error
	mov	[JNI_CreateJavaVM],eax

	invoke	JNI_CreateJavaVM,jvm,jni,jvm_args
	test	eax,eax
	js	init_error

	cominvk jni,FindClass,'java/util/zip/ZipFile'
	test	eax,eax
	jz	error
	mov	ebx,eax 		; handle of ZipFile class in EBX

	cominvk jni,GetMethodID,ebx,'<init>','(Ljava/lang/String;)V'
	test	eax,eax
	jz	error
	mov	esi,eax 		; ID of ZipFile(String) constructor in ESI

	cominvk jni,NewStringUTF,'test.zip'
	test	eax,eax
	jz	error
	; any method-calling routines need a C calling convention,
	; I added a "cominvc" macro for this:
	cominvc jni,NewObject,ebx,esi,eax
	test	eax,eax
	jz	error
	mov	edi,eax 		; handle of created ZipFile object in EDI

	cominvk jni,ExceptionClear

	cominvk jni,GetMethodID,ebx,'entries','()Ljava/util/Enumeration;'
	test	eax,eax
	jz	error
	cominvc jni,CallObjectMethod,edi,eax
	test	eax,eax
	jz	error
	stdcall ShowZipEntries,eax

	cominvk jni,ExceptionOccurred
	test	eax,eax
	jnz	error

	cominvk jni,GetMethodID,ebx,'close','()V'
	test	eax,eax
	jz	error
	cominvc jni,CallVoidMethod,edi,eax
	cominvk jni,DeleteLocalRef,edi	; delete our reference to object, then the
					;  garbage collector will take care of it

	cominvk jvm,DestroyJavaVM
	invoke	ExitProcess,0

error:
	cominvk jni,ExceptionDescribe
	cominvk jvm,DestroyJavaVM
	invoke	ExitProcess,1

init_error:
	invoke	ExitProcess,-1

proc ShowZipEntries uses ebx edi, EnumerationObject

  locals
    ID_hasMoreElements dd ?
    ID_nextElement dd ?
  endl
	cominvk jni,FindClass,'java/util/Enumeration'
	test	eax,eax
	jz	error
	mov	ebx,eax
	cominvk jni,GetMethodID,ebx,'hasMoreElements','()Z'
	test	eax,eax
	jz	error
	mov	[ID_hasMoreElements],eax
	cominvk jni,GetMethodID,ebx,'nextElement','()Ljava/lang/Object;'
	test	eax,eax
	jz	error
	mov	[ID_nextElement],eax

  locals
    ID_getName dd ?
  endl
	cominvk jni,FindClass,'java/util/zip/ZipEntry'
	test	eax,eax
	jz	error
	cominvk jni,GetMethodID,eax,'getName','()Ljava/lang/String;'
	test	eax,eax
	jz	error
	mov	[ID_getName],eax

  locals
    OutObject dd ?
  endl
	cominvk jni,FindClass,'java/lang/System'
	test	eax,eax
	jz	error
	mov	ebx,eax
	cominvk jni,GetStaticFieldID,ebx,'out','Ljava/io/PrintStream;'
	test	eax,eax
	jz	error
	cominvk jni,GetStaticObjectField,ebx,eax
	test	eax,eax
	jz	error
	mov	[OutObject],eax

  locals
    ID_println dd ?
  endl
	cominvk jni,FindClass,'java/io/PrintStream'
	test	eax,eax
	jz	error
	cominvk jni,GetMethodID,eax,'println','(Ljava/lang/String;)V'
	test	eax,eax
	jz	error
	mov	[ID_println],eax

  main_loop:
	cominvc jni,CallBooleanMethod,[EnumerationObject],[ID_hasMoreElements]
	test	al,al
	jz	done
	cominvc jni,CallObjectMethod,[EnumerationObject],[ID_nextElement]
	cominvc jni,CallObjectMethod,eax,[ID_getName]
	cominvc jni,CallVoidMethod,[OutObject],[ID_println],eax
	jmp	main_loop

  done:
	ret

endp

section '.data' data readable writeable

jvm_args '-Djava.class.path=.'

jvm_function db 'JNI_CreateJavaVM',0

JNI_CreateJavaVM dd ?
jvm JNIInvokeInterface
jni JNINativeInterface

jvm_library db 1000h dup ?

tmp dd ?

section '.rdata' data readable writeable

data import

  library kernel32,'KERNEL32.DLL',\
	  user32,'USER32.DLL',\
	  advapi32,'ADVAPI32.DLL'

  include 'api\kernel32.inc'
  include 'api\user32.inc'
  include 'api\advapi32.inc'

end data
