
macro jvm_args [option]
{
  common jvm_args:
   .version	       dd 0x00010002 ; 1.2
   .nOptions	       dd VM_NOPTIONS
   .options	       dd .options_array
   .ignoreUnrecognized dd 1

   .options_array:
   COUNTER = 0
  forward
   local .optionString
   dd .optionString,0
   COUNTER = COUNTER+1
  common
   VM_NOPTIONS = COUNTER
  forward
   .optionString db option,0
}

interface JNIInvokeInterface,\
	    reserved0,\
	    reserved1,\
	    reserved2,\
	    DestroyJavaVM,\
	    AttachCurrentThread,\
	    DetachCurrentThread,\
	    GetEnv

interface JNINativeInterface,\
	   reserved0,\
	   reserved1,\
	   reserved2,\
	   reserved3,\
	   GetVersion,\
	   DefineClass,\
	   FindClass,\
	   reserved4,\
	   reserved5,\
	   reserved6,\
	   GetSuperclass,\
	   IsAssignableFrom,\
	   reserved7,\
	   Throw,\
	   ThrowNew,\
	   ExceptionOccurred,\
	   ExceptionDescribe,\
	   ExceptionClear,\
	   FatalError,\
	   reserved8,\
	   reserved9,\
	   NewGlobalRef,\
	   DeleteGlobalRef,\
	   DeleteLocalRef,\
	   IsSameObject,\
	   reserved10,\
	   reserved11,\
	   AllocObject,\
	   NewObject,\
	   NewObjectV,\
	   NewObjectA,\
	   GetObjectClass,\
	   IsInstanceOf,\
	   GetMethodID,\
	   CallObjectMethod,\
	   CallObjectMethodV,\
	   CallObjectMethodA,\
	   CallBooleanMethod,\
	   CallBooleanMethodV,\
	   CallBooleanMethodA,\
	   CallByteMethod,\
	   CallByteMethodV,\
	   CallByteMethodA,\
	   CallCharMethod,\
	   CallCharMethodV,\
	   CallCharMethodA,\
	   CallShortMethod,\
	   CallShortMethodV,\
	   CallShortMethodA,\
	   CallIntMethod,\
	   CallIntMethodV,\
	   CallIntMethodA,\
	   CallLongMethod,\
	   CallLongMethodV,\
	   CallLongMethodA,\
	   CallFloatMethod,\
	   CallFloatMethodV,\
	   CallFloatMethodA,\
	   CallDoubleMethod,\
	   CallDoubleMethodV,\
	   CallDoubleMethodA,\
	   CallVoidMethod,\
	   CallVoidMethodV,\
	   CallVoidMethodA,\
	   CallNonvirtualObjectMethod,\
	   CallNonvirtualObjectMethodV,\
	   CallNonvirtualObjectMethodA,\
	   CallNonvirtualBooleanMethod,\
	   CallNonvirtualBooleanMethodV,\
	   CallNonvirtualBooleanMethodA,\
	   CallNonvirtualByteMethod,\
	   CallNonvirtualByteMethodV,\
	   CallNonvirtualByteMethodA,\
	   CallNonvirtualCharMethod,\
	   CallNonvirtualCharMethodV,\
	   CallNonvirtualCharMethodA,\
	   CallNonvirtualShortMethod,\
	   CallNonvirtualShortMethodV,\
	   CallNonvirtualShortMethodA,\
	   CallNonvirtualIntMethod,\
	   CallNonvirtualIntMethodV,\
	   CallNonvirtualIntMethodA,\
	   CallNonvirtualLongMethod,\
	   CallNonvirtualLongMethodV,\
	   CallNonvirtualLongMethodA,\
	   CallNonvirtualFloatMethod,\
	   CallNonvirtualFloatMethodV,\
	   CallNonvirtualFloatMethodA,\
	   CallNonvirtualDoubleMethod,\
	   CallNonvirtualDoubleMethodV,\
	   CallNonvirtualDoubleMethodA,\
	   CallNonvirtualVoidMethod,\
	   CallNonvirtualVoidMethodV,\
	   CallNonvirtualVoidMethodA,\
	   GetFieldID,\
	   GetObjectField,\
	   GetBooleanField,\
	   GetByteField,\
	   GetCharField,\
	   GetShortField,\
	   GetIntField,\
	   GetLongField,\
	   GetFloatField,\
	   GetDoubleField,\
	   SetObjectField,\
	   SetBooleanField,\
	   SetByteField,\
	   SetCharField,\
	   SetShortField,\
	   SetIntField,\
	   SetLongField,\
	   SetFloatField,\
	   SetDoubleField,\
	   GetStaticMethodID,\
	   CallStaticObjectMethod,\
	   CallStaticObjectMethodV,\
	   CallStaticObjectMethodA,\
	   CallStaticBooleanMethod,\
	   CallStaticBooleanMethodV,\
	   CallStaticBooleanMethodA,\
	   CallStaticByteMethod,\
	   CallStaticByteMethodV,\
	   CallStaticByteMethodA,\
	   CallStaticCharMethod,\
	   CallStaticCharMethodV,\
	   CallStaticCharMethodA,\
	   CallStaticShortMethod,\
	   CallStaticShortMethodV,\
	   CallStaticShortMethodA,\
	   CallStaticIntMethod,\
	   CallStaticIntMethodV,\
	   CallStaticIntMethodA,\
	   CallStaticLongMethod,\
	   CallStaticLongMethodV,\
	   CallStaticLongMethodA,\
	   CallStaticFloatMethod,\
	   CallStaticFloatMethodV,\
	   CallStaticFloatMethodA,\
	   CallStaticDoubleMethod,\
	   CallStaticDoubleMethodV,\
	   CallStaticDoubleMethodA,\
	   CallStaticVoidMethod,\
	   CallStaticVoidMethodV,\
	   CallStaticVoidMethodA,\
	   GetStaticFieldID,\
	   GetStaticObjectField,\
	   GetStaticBooleanField,\
	   GetStaticByteField,\
	   GetStaticCharField,\
	   GetStaticShortField,\
	   GetStaticIntField,\
	   GetStaticLongField,\
	   GetStaticFloatField,\
	   GetStaticDoubleField,\
	   SetStaticObjectField,\
	   SetStaticBooleanField,\
	   SetStaticByteField,\
	   SetStaticCharField,\
	   SetStaticShortField,\
	   SetStaticIntField,\
	   SetStaticLongField,\
	   SetStaticFloatField,\
	   SetStaticDoubleField,\
	   NewString,\
	   GetStringLength,\
	   GetStringChars,\
	   ReleaseStringChars,\
	   NewStringUTF,\
	   GetStringUTFLength,\
	   GetStringUTFChars,\
	   ReleaseStringUTFChars,\
	   GetArrayLength,\
	   NewObjectArray,\
	   GetObjectArrayElement,\
	   SetObjectArrayElement,\
	   NewBooleanArray,\
	   NewByteArray,\
	   NewCharArray,\
	   NewShortArray,\
	   NewIntArray,\
	   NewLongArray,\
	   NewFloatArray,\
	   NewDoubleArray,\
	   GetBooleanArrayElements,\
	   GetByteArrayElements,\
	   GetCharArrayElements,\
	   GetShortArrayElements,\
	   GetIntArrayElements,\
	   GetLongArrayElements,\
	   GetFloatArrayElements,\
	   GetDoubleArrayElements,\
	   ReleaseBooleanArrayElements,\
	   ReleaseByteArrayElements,\
	   ReleaseCharArrayElements,\
	   ReleaseShortArrayElements,\
	   ReleaseIntArrayElements,\
	   ReleaseLongArrayElements,\
	   ReleaseFloatArrayElements,\
	   ReleaseDoubleArrayElements,\
	   GetBooleanArrayRegion,\
	   GetByteArrayRegion,\
	   GetCharArrayRegion,\
	   GetShortArrayRegion,\
	   GetIntArrayRegion,\
	   GetLongArrayRegion,\
	   GetFloatArrayRegion,\
	   GetDoubleArrayRegion,\
	   SetBooleanArrayRegion,\
	   SetByteArrayRegion,\
	   SetCharArrayRegion,\
	   SetShortArrayRegion,\
	   SetIntArrayRegion,\
	   SetLongArrayRegion,\
	   SetFloatArrayRegion,\
	   SetDoubleArrayRegion,\
	   RegisterNatives,\
	   UnregisterNatives,\
	   MonitorEnter,\
	   MonitorExit,\
	   GetJavaVM

macro cominvc object,proc,[arg]
 { common
    local count
    count = 1
    if ~ arg eq
   reverse
     pushd arg
     count = count+1
   common
    end if
    mov eax,[object]
    push eax
    mov eax,[eax]
    call [eax+object#.#proc]
    add esp,count*4 }
